﻿// --------------------------------------------------------------------------
// Project Frocessing
// ActionScript 3.0 drawing library like Processing.
// --------------------------------------------------------------------------
//
// Frocessing drawing library
// Copyright (C) 2008-09  TAKANAWA Tomoaki (http://nutsu.com) and
//					   	  Spark project (www.libspark.org)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// contact : face(at)nutsu.com
//

package frocessing.bmp 
{
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.geom.Point;
	
	/**
	* ...
	* @author nutsu
	* @version 0.5
	*/
	public class FImage 
	{
		/**
		 * @private
		 */
		protected static const _zeropoint:Point = new Point();
		
		/**
		 * @private
		 */
		protected var _bitmapdata:BitmapData;
		
		private var _srcbitmap:BitmapData;
		private var _keep_src:Boolean = false;
		
		
		public function FImage( bitmapData:BitmapData ) 
		{
			_bitmapdata = bitmapData;
			_keep_src   = false;
			_srcbitmap  = null;
		}

		public function get bitmapData():BitmapData { return _bitmapdata; }
		
		//-------------------------------------------------------------------------------------------------------------------
		
		/**
		 * mask
		 * @param	alphaSrc	BitmapData
		 * @param	channel		Alpha　data BitmapDataChannel
		 */
		public function mask( alphaSrc:BitmapData, channel:uint=8 ):void
		{
			_bitmapdata.copyChannel( alphaSrc, _bitmapdata.rect, _zeropoint, channel, BitmapDataChannel.ALPHA );
		}
		
		/**
		 * alpha
		 */
		/*
		public function alpha( value:Number ):void
		{
			var alphadata:BitmapData = new BitmapData( _bitmapdata.width, _bitmapdata.height, true, uint( value * 0xff ) << 24 );
			_bitmapdata.copyChannel( alphadata, _bitmapdata.rect, _zeropoint, BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA );
			alphadata.dispose();
		}
		*/
		
		//-------------------------------------------------------------------------------------------------------------------
		
		/**
		 * オリジナルデータを保持している場合、データを復帰します.
		 */
		/*
		public function restore():void
		{
			if ( _keep_src )
				_bitmapdata.copyPixels( _srcbitmap, _bitmapdata.rect, zeropoint );
		}
		*/
		
		/**
		 * オリジナルデータを保持している場合、データを反映させます.
		 */
		/*
		public function store():void
		{
			if ( _keep_src )
				_srcbitmap.copyPixels( _bitmapdata, _bitmapdata.rect, zeropoint );
		}
		*/
		
		/**
		 * original bitmapdata.
		 */
		/*
		public function get original():BitmapData
		{
			if( _keep_src )
				return _srcbitmap;
			else
				return _bitmapdata;
		}
		*/
		
		/**
		 * keep original bitmapdata
		 */
		/*
		public function get keep():Boolean { return _keep_src; }
		public function set keep(value:Boolean):void 
		{
			if ( _keep_src != value )
			{
				_keep_src = value;
				if ( _keep_src )
				{
					_srcbitmap = _bitmapdata.clone();
				}
				else if ( _srcbitmap != null );
				{
					_srcbitmap.dispose();
					_srcbitmap = null;
				}
			}
		}
		*/
		
		//-------------------------------------------------------------------------------------------------------------------
		
		public function dispose():void
		{
			_bitmapdata.dispose();
			if ( _srcbitmap!=null )
				_srcbitmap.dispose();
		}
		
		//-------------------------------------------------------------------------------------------------------------------
		
		public function valueOf():BitmapData
		{
			return _bitmapdata;
		}
	}
	
}